4.2.2
  - BUGFIX: In the 4.2.1 release a bug was introduced that impacted
    the handling of poly-A tails and the naming of LINE annotations.
    While the overall masking level remained the same, the change 
    caused some previously hidden and overlapping annotations to 
    appear with invalid query ranges ( query start > query end ). 
    (github #362)
  - Added support for '+' symbol in input filenames. (github #365)

4.2.1
  - BUGFIX: An infinite loop was possible in rare circumstances
    involoving interleaved satellite consensi while using the
    "-a" option.  This caused the alignment file to keep growing
    and eventually ProcessRepeats to crash.
  - BUGFIX: Fix a one-off issue in alignment range calculations
    induced by the clipping mechanism in RepeatMasker.
  - BUGFIX: The configure script was crashing while attempting to
    import Repbase in the previous version.
  - Updated to the latest famdb version (2.0.5)
  - Crossmatch alignment format parser hardening.  While not proper, 
    negative coordinates can appear in the alignment file due to 
    incorrect range calculations.  This change allows for the parser
    to handle these cases and not mis-align the data columns.
  - Updated the length of the Charlie7 family in RepeatAnnotationData.pm
  
4.2.0
  - BUGFIX: For mammalian genomes searched using the "-species" option,
    newer Dfam families without search stages, or with the "-uncurated"
    flag Dfam DR families were not being included in the search.  
  - BUGFIX: RepeatMasker exits with an error code if no repetitive
    sequences were found in the input file.
  - BUGFIX: famdb.py was not reporting the correct counts for families
    ancestral to the query term.  RepeatMasker uses this count and therefore
    was also reporting an incorrect value.
  - Remove duplicate families when attempting to merge Repbase 
    RepeatMaskerEdition into FamDB.
  - The configure utility was not using the -libdir path when creating
    the RepeatMasker.lib file. (github #344)

4.1.9
  - BUGFIX: When the RepeatMasker adjudicator (ProcessRepeats) is 
    faced with a huge number of overlapping and redundant alignments 
    the joining can go awry, creating a infinite loop.  The effect
    is that ProcessRepeats never completes.
  - BUGFIX: When using nhmmer/pHMMs and a non-species-level "-species"
    parameters (e.g. "-species mammals"), RepeatMasker was using an
    exteremly permissive per-family score cutoff.  This overwhelmed
    ProcessRepeats with many low-scoring alignments.
  - BUGFIX: ProcessRepeats dies around line 8190 with a "Division by
    zero" error.
  - BUGFIX: Fixed call to famdb for buildSummary.pl in the -species 
    option.  Updated documentation.
  - Updated repeatmasker.help.

4.1.8
  - Fix table format for non-mammals.  The "Retroelements" heading
    didn't include Penelope elements ( "PLE/" ) in it's tabulation.
  - ProcessRepeats - A major change in how annotations are processed
    to reduce PR's memory footprint.  Instead of loading all anntations
    in memory, they are now streamed and processed a sequnce at a time.
    For chromosomal assemblies this reduced the memory footprint to
    the size of the largest chromosome, instead of the whole genome.
  - Fixed a bug that caused general/is.lib to be left in a unfrozen
    state for rmblastn.
  - Updated to Dfam3.9

4.1.7-p1
  - This is a critical fix to the 4.1.7 release.  The -species option
    was not being interpreted correctly by RepeatMasker/ProcessRepeats.
    The most obvious change for mammals/primates was that the output
    format (*.tbl file) looked different than it had before.  Under the
    hood this also changed the way some species were handled in the 
    library searches. 

4.1.7
  - Handle the case were the default search engine is not configured
    and require the user to provide it using -e/-engine.
  - Use the global alignment bandwidth simulation for the refinement
    step.
  - Allow for minimal database install and warn when used with -species.
  - Fixed a bug on configure with setting the default search engine when
    only one search engine is configured.
  - RepeatProteinMask wasn't obtaining the correct search engine if
    configure didn't set it up correctly.
  - FamDB wasn't exporting RepeatMasker.lib with class-name suffixes.
    This had an impact on the RepeatModeler/RepeatClassifier package
    but not on RepeatMasker itself. Upgraded to FamDB 1.0.5
  - Fixed an issue with parsing RepBase.  Some records were not being
    parsed correctly for records that do not include the keyword "repbase"
    following the identifier.
  - New semantantics for NCBIBlastSearchEngine bandwidth interpretation.
  - Fixed a divide-by-zero error in ProcessRepeat's merging of 
    DNA tranpsoson overlapping fragments.
  - FamDB fixed inconsistency between curated/uncurated counts vs
    exports.

4.1.6
  - Upgraded to FamDB 1.0.2 to support Dfam 3.8 and the new partitioned
    database format.
  - Added Libraries/RMRB_spec_to_tax.json to project.  This maps the
    RepBase taxanames to current NCBI tax_ids and needs to be refreshed
    with each new Dfam release.
  - Added softmasking support to NCBIBlastSearchEngine.pm.
  - Added new '--uncurated' flag to handle single export Dfam format.     
    If this flag is used the CONS/HMM cached directories will be suffixed
    with "_wunc".
  - Fixed sunk error messages from famdb.py.  Now they will be displayed
    and cause RepeatMasker to quit. 
  - Additional library setup steps and error checking for configure utility.
  - CAF documentation in SearchResult.
  - calcDivergenceFromAlign clarified use of "-a" in documentation.

4.1.5
  - Updated codebase for Dfam 3.7 compatibility (famdb format 4.3)
  - Penelope classification change caused *.tbl file accounting
    to place them in the Unknown category.  Also fixed landscape
    generation tool.
  - Added a new utility to merge *.out *.align files generated by
    running RepeatMasker serially.
  - Repbase Metadata is seriously out-of-date, updated species names
    so that they match the current NCBI Taxonomy names.
  - Fixed an issue with the HMM parser.  It wasn't recognizing 
    negative values for Tau with models that do not have GA thresholds.

4.1.4
  - Added support for RMBlast 2.13.0
  - Release of the TE genome browser visualization (UCSC) and trackhub
    generation tool.
  - New CpGSites and unadjusted Kimura stats in the *.align file.
  - Fixed a bug that caused the read-only state of the input fasta file
    to propogate to the intermediate files and cause the program to exit.
  - Removed DateRepeats as it's based on old library formats - this functionality
    will return with the refactored version of RM in the works.

4.1.3-p2
  - A recent change in 4.1.3 to correct blank fragment ID fields can in rare
    cases causing the error message: 'Can't call method "setLeftLinkedHit"'.
  - The RepeatAnnotationData.pm file containing necessary information for
    recognizing equivalent fragments of DNA transposons was missing data.
  - The MULE-MuDR class was added to the *.tbl file for "-lib" searches.

4.1.3
  - A new utility for generating trackHubs for our new UCSC TE visualization
  - Fix a bug where killing RM while starting up can leave the cached libraries
    in an inconsistent state. 
  - Fixed a bug where in rare cases the joined fragment ID field is blank
  - Merged in changes to Dupmasker supporting multi-threaded use
  - Fixed legacy RepBase taxonomic labels
  - Added support for GFF v3 output and fixed the utility/rmOutToGFF3.pl

4.1.2-p1
  - Releases 4.1.1-4.1.2 contained a bug with the processing of Alu sequences 
    in primates. The step where an initial annotation is refined into a 
    particular Alu subfamily was not performed and the annotations remained 
    labeled with the initial capture sequence ( AluJb, AluSx, or AluY ). 
    This patch release fixes this one issue.
  
4.1.2
  - Fixed 21 protein family classifications in RepeatProteinLib.
  - Fixed a problem with the generation of the RepeatMasker.lib file for use by 
    RepeatModeler. In release 4.1.1 it did not add the classification info to 
    this auxilary file.
  - Fixed a "log(0)" error that can cause the program to fault in rare circumstances.
  - buildSummary now supports FamDB and has improved documentation.
  - Bugfixes and improvements to FamDB.

4.1.1
  - Dfam (starting with version 3.2) is now distributed in the FamDB file format 
    based on HDF5, which has improved support for large datasets compared to the 
    EMBL and HMM formats that were previously used. RepeatMasker therefore includes
    a copy of famdb.py, and depends on the python package h5py.

      o The 'configure' script and other parts of RepeatMasker have been updated to 
        accomodate these changes.
      o The utilities 'queryTaxonomyDatabase.pl' and 'queryRepeatDatabase.pl' are no 
        longer included, since that data is now included in FamDB. The 'famdb.py' 
        tool can be used to make many of the same queries as the removed utilies, 
        and even more.

4.1.0
  - Refactored the RepeatMasker configuration system.  
    The changes make it easier to automate installation and/or
    bundle RepeatMasker.

4.0.9-p2
  - Another improvement in TRF error handling

4.0.9-p1 : Tue Apr 16 08:51:22 PDT 2019
  - Input files containing multiple FASTA sequences
    caused RepeatMasker to error out with a message
    like:

      "WARNING: TRF returned an error (Return code = ### )
       TRF parameters: 2.7.7.80.10.50.10
       A search phase could not complete on this batch.
       The batch file will be re-run and if possible the
       program will resume.
       WARNING: Retrying batch ( 1 ) [ 255,, 195]..."

    This bug was introduced in an attempt to improve TRF
    error catching.  Unfortunatly the return codes are
    not documented for TRF and the assumption that 256
    is the only successful return code is wrong.  The
    "success" code appears to change depending on the
    number of sequences in the file.  The workaround is
    to fail only if there is a message in the error output
    file.

